package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Locations")
public class LocationListView {

	@XmlElement(name="Location")
	private List<String> locations = new ArrayList<String>();

	public LocationListView() {}
	
	public LocationListView(Collection<String> locationList) {
		if (locationList != null && locationList.size() > 0) {
			locations.clear();
			locations.addAll(locationList);
		}
	}

	public List<String> getLocations() {
		return locations;
	}
	
}
